/*:ja
 * @plugindesc v1.04 イベントの移動ルートコマンドを拡張します
 * @author Yanfly Engine Plugins
 *
 * @help
 * 翻訳:ムノクラ
 * https://fungamemake.com/
 * https://twitter.com/munokura/
 *
 * ===========================================================================
 * 導入
 * ===========================================================================
 *
 * RPGツクールMVには、移動ルートに使用するためのコマンドが用意されています。
 * しかし、移動ルートコマンドはシステムに多くの制限を受けています。
 * このプラグインはイベントの移動ルートを構築し、
 * 移動ルート作成プロセスを合理化する追加の手段を提供します。
 *
 * ===========================================================================
 * 説明 - 簡略化された移動ルート
 * ===========================================================================
 *
 * プラグインのコマンドを使用してイベントを特定の方向に移動させるには、
 * 次の手順を実行します。
 *
 * 1. 移動したいイベントを開きます。
 * 2. 移動ルートコマンドまたは自律移動カスタムルートを作成します。
 * 3. "スクリプト..." を押します。
 * 4. 次のコマンドを入力してください。
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * UP: x
 * LEFT: x
 * RIGHT: x
 * DOWN: x
 * UPPER LEFT: x
 * UPPER RIGHT: x
 * LOWER LEFT: x
 * LOWER RIGHT: x
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントは指定された方向へ x 回移動します。
 * これは、エディタで方向を複数回挿入するのと同じですが、
 * これはコマンドを統合する方法として機能することを意味しています。
 * x を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Up: 10
 *     Left: 7
 *     Down: 3
 *     Right: 4
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * ANIMATION: x
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントでアニメーション x を再生します。
 * x を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Animation: 10
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * BALLOON: x
 * BALLOON: EXCLAMATION
 * BALLOON: !
 * BALLOON: QUESTION
 * BALLOON: ?
 * BALLOON: MUSIC NOTE
 * BALLOON: HEART
 * BALLOON: ANGER
 * BALLOON: SWEAT
 * BALLOON: COBWEB
 * BALLOON: SILENCE
 * BALLOON: ...
 * BALLOON: LIGHT BULB
 * BALLOON: ZZZ
 * BALLOON: USER 1
 * BALLOON: USER 2
 * BALLOON: USER 3
 * BALLOON: USER 4
 * BALLOON: USER 5
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントでフキダシID x を表示します。
 * x を整数値に置き換えるか、または上記の文字列のいずれかに置き換えて、
 * その特定のフキダシを作成します。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Balloon: 5
 *     Balloon: Heart
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * ICON BALLOON: x
 * ICON BALLOON: x to y
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * YEP_IconBalloons が必要です。
 * これは、指定されたイベントにアイコン x または x から y を使用している場合、
 * アイコン x を使用してアイコンフキダシを表示させます。
 * x と y を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Turn Away: 20, 30
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * JUMP FORWARD: x
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントは、向いている方向に x タイル分をジャンプします。
 * x を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Jump Forward: 5
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * JUMP TO: x, y
 * JUMP TO: EVENT x
 * JUMP TO: PLAYER
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントは、
 *   マップ上の座標 x, y
 *   イベント x （イベント x が存在する場合）
 *   プレーヤーの場所
 * にジャンプします。 x と y を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Jump To: 20, 30
 *     Jump To: Event 5
 *     Jump To: Player
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * MOVE TO: x, y
 * MOVE TO: EVENT x
 * MOVE TO: PLAYER
 *
 * AVOID MOVE TO: x, y
 * AVOID MOVE TO: EVENT x
 * AVOID MOVE TO: PLAYER
 *
 * CRASH MOVE TO: x, y
 * CRASH MOVE TO: EVENT x
 * CRASH MOVE TO: PLAYER
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントは、
 *   マップ上の座標 x, y
 *   イベント x （イベント x が存在する場合）
 *   プレーヤーの場所
 * に移動します。
 * イベントは、
 * マークされた場所に到達するための最適なルートを12回の反復で決定します。
 * イベントは、座標に到達するまでこのコマンドを繰り返し続けます。
 *
 * x と y を整数値に置き換えます。
 *
 * 'Move To'と 'Avoid Move To'は、移動先のパスを計算するときに、
 * 指定されたイベントがプレーヤーとプレーヤーのフォロワーを避けて
 * 移動するようにします。
 *
 * 'Crash Move To'はプレイヤーやフォロワーとの衝突を許します。
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Move To: 20, 30
 *     Move To: Event 5
 *     Move To: Player
 *     Avoid Move To: 30, 40
 *     Crash Move To: 40, 50
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * PATTERN LOCK: x
 * PATTERN UNLOCK
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * RPGツクールMVでは、移動ルートエディタ内で
 * 現在使用されているパターン（スプライトフレーム）を設定することができません。
 * このコマンドはそれを可能にします。
 * パターンロックを使用すると、ロック解除されるまでスプライトは
 * そのパターン位置にロックされたままになります。
 * x を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Pattern Lock: 0
 *     Pattern Lock: 2
 *     Pattern Unlock
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * SELF SWITCH x: ON
 * SELF SWITCH x: OFF
 * SELF SWITCH x: TOGGLE
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * セルフスイッチが設計したイベント（プレーヤーではない場合）が
 *   オン
 *   オフ
 *   オン/オフ入替え
 * に切り替わります。
 * x を A、B、C、Dに置き換えます。
 * YEP_SelfSwVar.js を使用している場合、数字も使用できます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Self Switch A: On
 *     Self Switch B: Off
 *     Self Switch 123: Toggle
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * SELF VARIABLE x: y
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * YEP_SelfSwVar.js が必要です。
 * これは指定されたイベントのセルフ変数 x を
 * （それがプレイヤーでない限り）y に設定します。
 * x を整数値に置き換えます。
 * y を整数値またはコードで置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Self Variable A: On
 *     Self Variable B: Off
 *     Self Variable 123: Toggle
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * STEP AWAY FROM: x, y
 * STEP AWAY FROM: EVENT x
 * STEP AWAY FROM: PLAYER
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントは、
 *   マップ座標 x, y
 *   マップ上のイベント x（イベント x が存在する場合）
 *   プレーヤーの現在位置
 * から1タイル離れた位置に移動します。
 * xとyを整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Step Away: 20, 30
 *     Step Away: Event 5
 *     Step Away: Player
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * STEP TOWARD: x, y
 * STEP TOWARD: EVENT x
 * STEP TOWARD: PLAYER
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントを
 *   マップ座標 x、y
 *   マップ上のイベント x（イベントxが存在する場合）
 *   プレイヤーの現在位置
 * に向かって1タイルステップ移動させます。
 * x と y を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Step Toward: 20, 30
 *     Step Toward: Event 5
 *     Step Toward: Player
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * TELEPORT: x, y
 * TELEPORT: EVENT x
 * TELEPORT: PLAYER
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 即座に指定されたイベントを
 *   マップ上の座標 x, y
 *   イベント x（イベント x が存在する場合）
 *   マップ上のプレイヤーの現在位置
 * にテレポートします。
 * x と y を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Teleport: 20, 30
 *     Teleport: Event 5
 *     Teleport: Player
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * TURN AWAY FROM: x, y
 * TURN AWAY FROM: EVENT x
 * TURN AWAY FROM: PLAYER
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントは、
 *   マップ座標 x, y
 *   マップ上のイベント x（イベント x が存在する場合）
 *   プレイヤーの位置
 * から離れます。
 * x と y を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Turn Away: 20, 30
 *     Turn Away: Event 5
 *     Turn Away: Player
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * TURN TOWARDS: x, y
 * TURN TOWARDS: EVENT x
 * TURN TOWARDS: PLAYER
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 指定されたイベントは、
 *   マップ座標 x, y
 *   マップ上のイベント x（イベント x が存在する場合）
 *   プレーヤーの現在位置
 * に向かってタイルを進みます。
 * x と y を整数値に置き換えます。
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 例: Turn Towards: 50, 60
 *     Turn Towards: Event 5
 *     Turn Towards: Player
 * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 *
 * ===========================================================================
 * メモタグ
 * ===========================================================================
 *
 * 下記はイベントに利用できるメモタグです。
 *
 * イベントのメモタグ:
 *
 *   <Always Update Movement>
 *   - ほとんどのイベントは、画面に表示されない限り更新されません。
 *   しかし、このメモタグを持つイベントは、
 *   画面に表示されているかどうかにかかわらず、常に更新されます。
 *
 * ===========================================================================
 * ルナティックモード - スクリプトコール
 * ===========================================================================
 *
 * 単純化されたコマンドではなく
 * JavaScript を使って、コマンド機能を使用したい場合、
 * スクリプト内で次のコードを使用できます。
 *
 *   this.jumpForward(x)
 *   - 指定したイベントを前方にジャンプさせるタイルの数で x を置き換えます。
 *   x が float値の場合、x は自動的に最も近い整数値に丸められます。
 *
 *   this.jumpToPoint(x, y)
 *   - x と y を指定されたイベントのジャンプ先の座標に置き換えます。
 *   x と y が float値の場合、最も近い整数値に自動的に丸められます。
 *
 *   this.jumpToEvent(x)
 *   - x を、指定されたイベントがジャンプしたいイベントのIDに置き換えます。
 *   x が float値の場合、x は自動的に最も近い整数値に丸められます。
 *   0の場合、プレイヤーを参照します。
 *
 *   this.moveRepeat(direction, times)
 *   - 指定されたイベントを「方向」に一定「回」動かします。
 *   'direction'をイベントの移動先の数値に置き換え（テンキー参照）、
 *   'times'をその方向に進む回数に置き換えます。
 *
 *   this.moveToPoint(x, y)
 *   - 指定されたイベントが座標 x, y に到達するための最短移動ルートを
 *   12回の反復以内に計算します。
 *   イベントは、座標に到達するまでこのコマンドを繰り返し続けます。
 *   イベントはプレイヤーとフォロワーを避けてマップ上を移動します。
 *
 *   this.moveToPoint(x, y, true)
 *   - 指定されたイベントが座標 x, y に到達するための最短移動ルートを
 *   12回の反復以内に計算します。
 *   イベントは、座標に到達するまでこのコマンドを繰り返し続けます。
 *   イベントはプレイヤーや他のフォロワーが最短距離にいる場合、
 *   衝突させます。
 *
 *   this.moveToEvent(x)
 *   - 指定されたイベントが座標 x, y に到達するための最短移動ルートを
 *   12回の反復以内に計算します。
 *   イベントは、座標に到達するまでこのコマンドを繰り返し続けます。
 *   0の場合、プレイヤーを参照します。
 *   イベントはプレイヤーとフォロワーを避けてマップ上を移動します。
 *
 *   this.moveToEvent(x, true)
 *   - 指定されたイベントが座標 x, y に到達するための最短移動ルートを
 *   12回の反復以内に計算します。
 *   イベントは、座標に到達するまでこのコマンドを繰り返し続けます。
 *   0の場合、プレイヤーを参照します。
 *   イベントはプレイヤーや他のフォロワーが最短距離にいる場合、
 *   衝突させます。
 *
 *   this.requestAnimation(x)
 *   - x を指定したイベントで再生したいアニメーションIDに置き換えます。
 *   x が float値の場合、x は最も近い整数値に丸められます。
 *
 *   this.requestBalloon(x)
 *   - x を指定したイベントで再生したいフキダシIDに置き換えます。
 *   x が float値の場合、x は最も近い整数値に丸められます。
 *
 *   this.stepAwayFromPoint(x, y)
 *   - x と y を、指定されたイベントから離れたい座標に置き換えます。
 *   x と y が float値の場合、最も近い整数値に丸められます。
 *
 *   this.stepAwayFromEvent(x)
 *   - x を、指定したイベントから離れたいイベントのIDに置き換えます。
 *   x が float値の場合、x は最も近い整数値に丸められます。
 *   0の場合、プレイヤーを参照します。
 *
 *   this.stepTowardPoint(x, y)
 *   - x と y を、指定したイベントが進むべき座標に置き換えます。
 *   x と y が float値の場合、最も近い整数値に丸められます。
 *
 *   this.stepTowardPoint(x, y)
 *   - x と y を、指定したイベントが進むべき座標に置き換えます。
 *   x と y が float値の場合、最も近い整数値に丸められます。
 *
 *   this.stepTowardEvent(x)
 *   - x を指定したイベントが進む先のイベントのIDに置き換えます。
 *   x が float値の場合、x は最も近い整数値に丸められます。
 *   0の場合、プレイヤーを参照します。
 *
 *   this.teleportToPoint(x, y)
 *   - x と y を指定のイベントのテレポート先の座標に置き換えます。
 *   x と y がfloat値の場合、最も近い整数値に丸められます。
 *
 *   this.teleportToEvent(x)
 *   - x を指定したイベントをテレポートするイベントのIDに置き換えます。
 *   x が float値の場合、x は最も近い整数値に丸められます。
 *   0の場合、プレイヤーを参照します。
 *
 *   this.turnAwayFromPoint(x, y)
 *   - x と y を指定されたイベントの方向を変えたい座標に置き換えます。
 *   x と y が float値の場合、最も近い整数値に丸められます。
 *
 *   this.turnAwayFromEvent(x)
 *   - x を指定された予定を元に戻す予定の予定のIDに置き換えます。
 *   x が float値の場合、x は最も近い整数値に丸められます。
 *   0の場合、プレイヤーを参照します。
 *
 *   this.turnTowardPoint(x, y)
 *   - x と y を指定されたイベントが向けられる座標に置き換えます。
 *   x と y が float値の場合、最も近い整数値に丸められます。
 *
 *   this.turnTowardEvent(x)
 *   - x を指定されたイベントに向けたいイベントのIDに置き換えます。
 *   x が float値の場合、x は最も近い整数値に丸められます。
 *   0の場合、プレイヤーを参照します。
 *
 * ===========================================================================
 * Changelog
 * ===========================================================================
 *
 * Version 1.04:
 * - Fixed a bug that caused UP, LEFT, RIGHT, DOWN repeats to stack when used
 * with a repeating movement pattern.
 *
 * Version 1.03:
 * - Bypass the isDevToolsOpen() error when bad code is inserted into a script
 * call or custom Lunatic Mode code segment due to updating to MV 1.6.1.
 *
 * Version 1.02:
 * - Updated for RPG Maker MV version 1.5.0.
 *
 * Version 1.01:
 * - Bug fixed for the repeated commands that caused the commands to add upon
 * one another.
 *
 * Version 1.00:
 * - Finished Plugin!
 */
